package gov.va.med.domain.service.messaging.handler;

/**
 * Thrown by a IMessageHandler when an exception occurs that DOES NOT
 * warrant a rety later.  This will cause the originating Message
 * to be place in an error state for troubleshooting.    
 *  
 * @author Joel Goldberg
 * @version $Id: UnrecoverableHandlerException.java,v 1.5 2005/09/12 21:18:17 slava.uchitel Exp $
 * @since
 */
public class UnrecoverableHandlerException extends RuntimeException {

    private static final long serialVersionUID = 3256442512536514868L;

    public UnrecoverableHandlerException() {
        super();
    }

    public UnrecoverableHandlerException(String s) {
        super(s);
    }

    public UnrecoverableHandlerException(Throwable throwable) {
        super(throwable);
    }

    public UnrecoverableHandlerException(String s, Throwable throwable) {
        super(s, throwable);
    }

}
